jQuery(document).ready(function($){
	var $preview = $('#mtsg-preview');
	var $generated = $('#mtsg-generated-shortcode');
	var $list = $('#mtsg-list');

	function merge_options(obj1,obj2){
        var obj3 = {};
        for (var attrname in obj1) { obj3[attrname] = obj1[attrname]; }
        for (var attrname in obj2) { obj3[attrname] = obj2[attrname]; }
        return obj3;
    }
    var classes = {
        themeClass: 'mtswpt-theme',
        baseClass: 'mtswpt-carousel',
        itemClass: 'mtswpt-item',
        navContainerClass: 'mtswpt-nav',
        itemClass: 'mtswpt-item',
        navClass: '[&#x27;mtswpt-prev&#x27;,&#x27;mtswpt-next&#x27;]',
        controlsClass: 'mtswpt-controls',
        dotClass: 'mtswpt-dot',
        dotsClass: 'mtswpt-dots',
        autoHeightClass: 'mtswpt-height'
    }

	// HTML Preview
	var updatePreview = function() {
		$preview.addClass('loading');
		$.ajax({
			url: ajaxurl,
			type: 'POST',
			dataType: 'html',
			data: {action: 'testimonial_preview_shortcode', shortcode: $generated.val()},
		})
		.done(function(data) {
			$preview.html(data);
			// carousel quick fix
			if ($('#layout').val() == 'carousel_testimonial_grid') {
				var transition = parseInt( $('.testimonial-slider').attr('data-autplay-transition') );
				if( transition == '' ){ transition = 3000; }
				$('.testimonial-slider').owlCarousel(merge_options({
				    items:2,
				    loop:true,
				    margin:10,
				    autoplay:true,
				    autoplayTimeout: transition,
				    autoplayHoverPause:true
				}, classes));
			} else if ($('#layout').val() == 'carousel_testimonial') {
				var transition = parseInt( $('.testimonial-slider').attr('data-autplay-transition') );
				if( transition == '' ){ transition = 3000; }
				$('.testimonial-slider').owlCarousel(merge_options({
				    items:1,
				    loop:true,
				    margin:0,
				    autoplay:true,
				    autoplayTimeout: transition,
				    autoplayHoverPause:true
				}, classes));
			}
		}).always(function() {
			$preview.removeClass('loading');
		});
	};
	$generated.change(function(event) {
		updatePreview();
	});

	// Shortcode preview
	var updateShortcode = function() {
		var shortcode = '[mts_testimonial';
		$('#mtsg-form').find('input, select').each(function(index, el) {
			var $this = $(this);
			var val = $this.val();
			var name = $this.attr('name');
			if ($this.is('input[type=hidden], input[type=button]')) return true;
			if (!name) return true;
			if (name == 'display_by') return true;

			if ($('#display_by').val() == 'id') {
				if (name == 'category' || name == 'number' || name == 'order_by' || name == 'carousel_transition') return true;
			}

			if ($this.is('input[type=checkbox]')) {
				if (!$this.is(':checked'))
					val = '';
			}
			if (val === null) val = '';
			shortcode += ' '+name+'="'+val+'"';

		});
		shortcode += ']';
		$generated.val(shortcode).trigger('change');
	};
	$('#mtsg-form').find('input, select').change(function() {
		updateShortcode();
	});

	$('#mtsg-generated-shortcode').click(function() {
		$(this).select();
	});
	$('#mtsg-preview-wrapper').resizable({
	    handles: 'e',
	    containment: '.wrap',
	    minWidth: 300,
	    stop: function() {
	    	window.dispatchEvent(new Event('resize')); // resize carousel
	    }
	});
	var colortimer;
	$('.mtsg-field-color input').wpColorPicker({
		change: function(event, ui) {
			clearTimeout(colortimer);
			colortimer = setTimeout(function() { updateShortcode(); }, 500);
		}
	});
	var $select = $('#testimonials').selectize({});
	$('#display_by').change(function(event) {
		var val = $(this).val();
		if (val == 'query') {
			$('.mtsg-query-options').show();
			$('.mtsg-id-options').hide();
			var selectize = $select[0].selectize;
        	selectize.clear();
		} else {
			$('.mtsg-query-options').hide();
			$('.mtsg-id-options').show();
		}
	}).trigger('change');
	$('#layout').change(function(event) {
		var val = $(this).val();
		if (val == 'carousel_testimonial_grid' || val == 'carousel_testimonial' ) {
			$('.mts_carousel_transition').show();
			$('#carousel_transition').show();
			$('#carousel_transition').val('3');
		} else {
			$('#carousel_transition').hide();
			$('.mts_carousel_transition').hide();
		}
	}).trigger('change');
});
